<?php
namespace VM\FinancialStatementsBundle\Services;

class SprawozdawczoscUproszczona
{
    protected $Sprawozdania;
    protected $Sprawozdawczosc;

    /**
     * @var int
     */
    protected $rokPoczatkowy = 1;

    /**
     * @var int
     */
    protected $rozmiarTablic = 1;

    /**
     * Constructor
     */
    public function __construct(Sprawozdania $Sprawozdania)
    {
        $this->Sprawozdania = $Sprawozdania;
        $this->Sprawozdawczosc = new \stdClass();

        $this->rokPoczatkowy = $Sprawozdania->getResultsOf('rokPoczatkowy');
        $this->rozmiarTablic = $Sprawozdania->getResultsOf('rozmiarTablic');

        $this->buildSprawozdawczosc();

        $this->evaluateSprawozdawczosc();
    }

    protected function buildEmptyArrays()
    {
        return array_fill($this->rokPoczatkowy, $this->rozmiarTablic, 0);
    }

    protected function buildSprawozdawczosc()
    {
        $spr = $this->Sprawozdawczosc;

        $spr->stanSrodkowNaPoczatekRoku = $this->buildEmptyArrays();

        $spr->rachunekZyskowIStrat = new \stdClass();
        $spr->rachunekZyskowIStrat->przychodyNettoZeSprzedazy = $this->buildEmptyArrays();
        $spr->rachunekZyskowIStrat->kosztyZmienne = $this->buildEmptyArrays();
        $spr->rachunekZyskowIStrat->kosztyStale = $this->buildEmptyArrays();
        $spr->rachunekZyskowIStrat->amortyzacja = $this->buildEmptyArrays();
        $spr->rachunekZyskowIStrat->przychodyFinansowe = $this->buildEmptyArrays();
        $spr->rachunekZyskowIStrat->kosztyFinansowe = $this->buildEmptyArrays();
        $spr->rachunekZyskowIStrat->zyskBrutto = $this->buildEmptyArrays();
        $spr->rachunekZyskowIStrat->podatekDochodowy = $this->buildEmptyArrays();
        $spr->rachunekZyskowIStrat->zyskNetto = $this->buildEmptyArrays();

        $spr->rachunekPrzeplywowPienieznych = new \stdClass();
        $spr->rachunekPrzeplywowPienieznych->nakladyInwestycyjne = $this->buildEmptyArrays();
        $spr->rachunekPrzeplywowPienieznych->nakladyNaKapitalPracujacy = $this->buildEmptyArrays();
        $spr->rachunekPrzeplywowPienieznych->zaciagniecieKredytowIPozyczek = $this->buildEmptyArrays();
        $spr->rachunekPrzeplywowPienieznych->splataKredytowIPozyczek = $this->buildEmptyArrays();

        $spr->stanWyrobowGotowych = $this->buildEmptyArrays();

        $spr->stanSrodkowNaKoniecRoku = $this->buildEmptyArrays();

    }

    protected function evaluateSprawozdawczosc()
    {
        $spr = $this->Sprawozdawczosc;
        $rachPrzeplywow = $this->Sprawozdania->getResultsOf('RachunekPrzeplywowPienieznych');
        $rachZyskow = $this->Sprawozdania->getResultsOf('RachunekZyskowIStrat');
        $aktywa = $this->Sprawozdania->getResultsOf('Aktywa');

        for($i = $this->rokPoczatkowy; $i < $this->rokPoczatkowy+$this->rozmiarTablic; $i++)
        {
            $produkcja = $this->Sprawozdania->getResultsOf('FinansowanieProdukcji')->getWariantProporcjonalnyByYear($i);

            $spr->stanSrodkowNaPoczatekRoku[$i] = $rachPrzeplywow->srodkiNaPoczatekOkresu[$i];

            $spr->rachunekZyskowIStrat->przychodyNettoZeSprzedazy[$i] =
//                $i == $this->rokPoczatkowy? 0:
                $rachZyskow->przychodyNettoZeSprzedazy->razem[$i];
            $spr->rachunekZyskowIStrat->kosztyZmienne[$i] =
//                $i == $this->rokPoczatkowy? 0:
                $produkcja->kosztyZmienneRazem;
            $spr->rachunekZyskowIStrat->amortyzacja[$i] =
//                $i == $this->rokPoczatkowy? 0:
                $rachZyskow->kosztyDzialalnosciOperacyjnej->amortyzacja[$i];

            $spr->rachunekZyskowIStrat->kosztyStale[$i] =
//                $i == $this->rokPoczatkowy? 0:
                $produkcja->kosztyStaleRazem + $produkcja->kosztyUtrzymaniaJakosci +
                $spr->rachunekZyskowIStrat->amortyzacja[$i];

            $spr->rachunekZyskowIStrat->przychodyFinansowe[$i] =
//                $i == $this->rokPoczatkowy? 0:
                $rachZyskow->przychodyFinansowe[$i];
            $spr->rachunekZyskowIStrat->kosztyFinansowe[$i] =
//                $i == $this->rokPoczatkowy? 0:
                $rachZyskow->kosztyFinansowe[$i];
            $spr->rachunekZyskowIStrat->zyskBrutto[$i] =
//                $i == $this->rokPoczatkowy? 0:
                $spr->rachunekZyskowIStrat->przychodyNettoZeSprzedazy[$i] -
                $spr->rachunekZyskowIStrat->kosztyZmienne[$i] -
                $spr->rachunekZyskowIStrat->kosztyStale[$i] +
                $spr->rachunekZyskowIStrat->przychodyFinansowe[$i] -
                $spr->rachunekZyskowIStrat->kosztyFinansowe[$i];
            $spr->rachunekZyskowIStrat->podatekDochodowy[$i] =
//                $i == $this->rokPoczatkowy? 0:
                $rachZyskow->podatekDochodowy[$i];
            $spr->rachunekZyskowIStrat->zyskNetto[$i] =
//                $i == $this->rokPoczatkowy? 0:
                $spr->rachunekZyskowIStrat->zyskBrutto[$i] -
                $spr->rachunekZyskowIStrat->podatekDochodowy[$i];

            $spr->rachunekPrzeplywowPienieznych->nakladyInwestycyjne[$i] =
                $rachPrzeplywow->przeplywySrodkowZDzialalnosciInwestycyjnej->nakladyInwestycyjne[$i];
            $spr->rachunekPrzeplywowPienieznych->nakladyNaKapitalPracujacy[$i] =
//                $i == $this->rokPoczatkowy? 0:
                -
                $rachPrzeplywow->przeplywySrodkowZDzialalnosciOperacyjnej->korekty->zmianaStanuZapasow[$i] -
                $rachPrzeplywow->przeplywySrodkowZDzialalnosciOperacyjnej->korekty->zmianaStanuNaleznosci[$i] -
                $rachPrzeplywow->przeplywySrodkowZDzialalnosciOperacyjnej->korekty->zmianaStanuZobowiazanKrotkoterminowych[$i];
            $spr->rachunekPrzeplywowPienieznych->zaciagniecieKredytowIPozyczek[$i] =
                $rachPrzeplywow->przeplywySrodkowZDzialalnosciFinansowej->wplywy->razem[$i];
            $spr->rachunekPrzeplywowPienieznych->splataKredytowIPozyczek[$i] =
//                $i == $this->rokPoczatkowy? 0:
                $rachPrzeplywow->przeplywySrodkowZDzialalnosciFinansowej->wydatki->razem[$i];
            $spr->stanSrodkowNaKoniecRoku[$i] =
				$rachPrzeplywow->srodkiNaKoniecOkresu[$i];
//                $spr->stanSrodkowNaPoczatekRoku[$i] + $spr->rachunekZyskowIStrat->zyskNetto[$i] -
//                ($spr->rachunekPrzeplywowPienieznych->nakladyInwestycyjne[$i] +
//                $spr->rachunekPrzeplywowPienieznych->nakladyNaKapitalPracujacy[$i]) +
//                $spr->rachunekPrzeplywowPienieznych->zaciagniecieKredytowIPozyczek[$i] -
//                $spr->rachunekPrzeplywowPienieznych->splataKredytowIPozyczek[$i] +
//                $spr->rachunekZyskowIStrat->amortyzacja[$i];

            $spr->stanWyrobowGotowych[$i] = $aktywa->obrotowe->zapasy[$i];
        }
    }

    public function getSprawozdawczoscUproszczona()
    {
        return $this->Sprawozdawczosc;
    }

    public function getSprawozdania()
    {
        return $this->Sprawozdania->getAll();
    }
}

?>
